VERSION 5.00
Begin VB.Form fCairoDemo 
   Caption         =   "Cairo-Tutorial"
   ClientHeight    =   8055
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   10800
   LinkTopic       =   "Form1"
   ScaleHeight     =   8055
   ScaleWidth      =   10800
   StartUpPosition =   3  'Windows-Standard
   Begin VB.ComboBox cmbSource 
      Height          =   315
      ItemData        =   "fCairoDemo.frx":0000
      Left            =   4320
      List            =   "fCairoDemo.frx":000A
      Style           =   2  'Dropdown-Liste
      TabIndex        =   3
      Top             =   60
      Width           =   3285
   End
   Begin VB.ComboBox cmbFillRule 
      Height          =   315
      ItemData        =   "fCairoDemo.frx":005C
      Left            =   2040
      List            =   "fCairoDemo.frx":0066
      Style           =   2  'Dropdown-Liste
      TabIndex        =   2
      Top             =   60
      Width           =   2055
   End
   Begin VB.CheckBox chkShowControlPoints 
      Caption         =   "Show ControlPoints"
      Height          =   315
      Left            =   90
      TabIndex        =   1
      Top             =   90
      Value           =   1  'Aktiviert
      Width           =   1815
   End
   Begin CairoTutorial.ucCanvas ucCanvas1 
      Height          =   4515
      Left            =   30
      TabIndex        =   0
      Top             =   480
      Width           =   8175
      _ExtentX        =   14420
      _ExtentY        =   7964
   End
End
Attribute VB_Name = "fCairoDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private CPs() As cControlPoint
Private WithEvents CenterDrag As cControlPoint
Attribute CenterDrag.VB_VarHelpID = -1

Private Sub Form_Load()
  Caption = "Drag the Control-Points"
  Me.ScaleMode = vbPixels

Dim i&, R As Double, TwoPI As Double, A As Double, AngleStep As Double
  'Ok, this time we will construct a 5-Corner-Star explicitely (without using CC.DrawRegularPolygon)
  'The constructed polygon-points are stored within ControlPoint-objects first (to allow dragging-interaction),
  'and later on in the Drawing-Routine the same PolyPoint-Coords are used, to define a Clipping-Path
  'Cairo-Clipping will not only work with Polygon-Paths of course, but with any Path-definition
  'as e.g. simple Paths as Rectangles or Circles - but also complex Paths - as e.g. Textout-Paths
  
  'But as said, here we demonstrate the Clipping, based on a "5-Point-Star-Polygon" - thereby
  'also demonstrating the two different Cairo-FillRules for Polygons (which I forgot in the examples
  'so far - so, please play around with the appropriate ComboBox-settings on the Form, to see the differences
  
  Set CenterDrag = ucCanvas1.ControlPoints.Add("CenterDrag", 300, 250, vbGreen, 9)
  TwoPI = 8 * Atn(1)
  AngleStep = TwoPI / 5
  R = 150
  
  ReDim CPs(0 To 4)
  For i = 0 To UBound(CPs)
    A = A + 2 * AngleStep
    Set CPs(i) = ucCanvas1.ControlPoints.Add("P" & i, CenterDrag.X + R * Sin(A), CenterDrag.Y - R * Cos(A), vbBlue, 6)
  Next i
  
  'the usage of the Cairo.Imagelist is recommended, to store "pixel-resources" which are repeatedly used later on
  'in the application - in our case here, we load and store an image-resource, which will later on act as a clipped source
  Cairo.ImageList.AddImage "SourceImage", App.Path & "\cubes.jpg"
  
  cmbFillRule.ListIndex = 1
  cmbSource.ListIndex = 0
End Sub

Private Sub Form_Resize()
  If ScaleHeight - ucCanvas1.Top > 0 Then ucCanvas1.Move 0, ucCanvas1.Top, ScaleWidth, ScaleHeight - ucCanvas1.Top
End Sub

'------- the different "Control-Changed"-Events all doing the same refresh, a simple: Draw ucCanvas.CC ----------
Private Sub chkShowControlPoints_Click()
  Draw ucCanvas1.CC
End Sub

Private Sub cmbFillRule_Click()
  Draw ucCanvas1.CC
End Sub

Private Sub cmbSource_Click()
  Draw ucCanvas1.CC
End Sub

Private Sub CenterDrag_PositionChanging(NewX As Double, NewY As Double)
Dim i&
  For i = 0 To UBound(CPs)
    CPs(i).Move CPs(i).X + NewX - CenterDrag.X, CPs(i).Y + NewY - CenterDrag.Y
  Next i
End Sub

'------------- End of "Control-Changed"-Event-Handling ------------------


Private Sub ucCanvas1_RefreshContents(CC As dhCairo.cCairoContext)
  Draw CC
End Sub

Private Sub Draw(CC As cCairoContext)
Dim i&, PolyArr() As Double

  'just a simple copy-over from the ControlPoint-Coords into a consecutive XY-PolyArray
  ReDim PolyArr(0 To 2 * UBound(CPs) + 1)
  For i = 0 To UBound(CPs)
    PolyArr(2 * i) = CPs(i).X
    PolyArr(2 * i + 1) = CPs(i).Y
  Next i
  
  'the following two lines ensure a complete Surface-Fill
  CC.SetSourceColor vbWhite
  CC.Paint
  
  CC.Save
    
    CC.FillRule = cmbFillRule.ListIndex

    CC.Polygon PolyArr, True   'we create just the "pure" Path
    CC.Clip 'now the just defined Polygon-Path above is acting like as the clipping-mask
      
      If cmbSource.ListIndex = 0 Then 'just the decision, which Source we place in CC, before our (clipped) CC.Paint
        CC.SetSourceColor vbCyan
      Else
        CC.SetSourceSurface Cairo.ImageList("SourceImage")
      End If
      
      CC.Paint 'without the clipping, the whole Surface would be filled with either the vbCyan- or the Image-Source
    CC.ResetClip 'good style, to cleanup the clipping-mask after we're done ;-)
    
  CC.Restore
  
  ucCanvas1.Refresh chkShowControlPoints.Value = 1
End Sub
